<x-user.content>
    <x-slot:title>Detail Produk</x-slot:title>
    <x-slot:head> </x-slot:head>
    <div class="container-fluid">
        <div class="row px-xl-5">
            <div class="col-12">
                <nav class="breadcrumb bg-light mb-30">
                    <a class="breadcrumb-item text-dark" href="/">Home</a>
                    <span class="breadcrumb-item active"> Detail</span>
                </nav>
            </div>
        </div>
    </div>

    <div class="container-fluid pb-5">
        <div class="row px-xl-5">
            <div class="col-lg-5 mb-30">
                <div id="product-carousel" class="carousel slide" data-ride="carousel">
                    <div class="carousel-inner bg-light">
                        <div class="carousel-item active">
                            @if ($p->gambar != null)
                                <img class="w-100 h-100" src="{{ asset('/storage/produk/' . $p->gambar) }}"
                                    alt="produk">
                            @else
                                <img alt="produk" class="w-100 h-100" src="{{ asset('storage/produk/produk.jpg') }}">
                            @endif
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-7 h-auto mb-30" id="detail">
                <div class="h-100 bg-light p-30">
                    <h3>{{ $p->nm_produk }}</h3>

                    @if ($p->diskon == 0)
                        <h3 class="font-weight-semi-bold mb-4">Rp. {{ number_format($p->harga_jual, 0, ',', '.') }}</h3>
                    @else
                        <h4 class="font-weight-semi mb-4"><del>Rp.
                                {{ number_format($p->harga_jual, 0, ',', '.') }}</del></h4>
                        <h3 class="font-weight-semi-bold mb-4">Rp.
                            {{ number_format($p->harga_jual - ($p->harga_jual * $p->diskon) / 100, 0, ',', '.') }}</h3>
                    @endif
                    <h6>Stok : {{ stok($p->id) - terjual($p->id) }}</h6>
                    <br>

                    <div class="d-flex align-items-center mb-4 pt-2 ">
                        <div class="input-group quantity mr-3" style="width: 130px;">
                            <div class="input-group-btn">
                                <button class="btn btn-danger btn-minus">
                                    <i class="fa fa-minus"></i>
                                </button>
                            </div>
                            <input type="text" id="qty" class="form-control bg-secondary border-0 text-center"
                                value="1" min="1" readonly>
                            <div class="input-group-btn">
                                <button class="btn btn-success btn-plus tambah">
                                    <i class="fa fa-plus"></i>
                                </button>
                            </div>
                        </div>
                        @php
                            $stok = stok($p->id) - terjual($p->id);
                        @endphp
                        <button
                            class="btn btn-danger px-3 mr-3 d-none d-lg-block {{ $stok == 0 ? 'disabled' : 'keranjang' }}"
                            data-kd="{{ $p->kd_produk }}">
                            <i class="fa fa-cart-plus mr-1"></i>
                            {{ $stok == 0 ? 'Stok Habis' : 'Masukan  Keranjang' }}
                        </button>

                        <button
                            class="btn btn-success px-3 d-none d-lg-block   {{ $stok == 0 ? 'disabled' : 'beli_sekarang' }}"
                            data-kd="{{ $p->kd_produk }}"> <i class="fa fa-shopping-cart mr-1"></i>
                            {{ $stok == 0 ? 'Stok Habis' : 'Beli Sekarang' }}
                        </button>

                    </div>

                    <button class="btn btn-danger px-3 mr-3 d-lg-none mb-2 {{ $stok == 0 ? 'disabled' : 'keranjang' }}"
                        data-kd="{{ $p->kd_produk }}">
                        <i class="fa fa-cart-plus mr-1"></i>
                        {{ $stok == 0 ? 'Stok Habis' : 'Masukan  Keranjang' }}

                    </button>

                    <button class="btn btn-success px-3 d-lg-none mb-2 {{ $stok == 0 ? 'disabled' : 'beli_sekarang' }}"
                        data-kd="{{ $p->kd_produk }}">
                        <i class="fa fa-shopping-cart mr-1"></i> {{ $stok == 0 ? 'Stok Habis' : 'Beli Sekarang' }}
                    </button>

                    <br>
                    <br>
                    Deskripsi :
                    <p class="mb-4">{!! $p->ktr_produk !!}</p>
                </div>
            </div>
        </div>



    </div>

    <input type="hidden" name="" id="stok" value="{{ $stok }}">
    <div class="container vh-100"></div>
    <x-slot:foot>
        <script>
            $('.tambah').click(function() {
                var qty = $('#qty').val();
                var stok = $('#stok').val();
                if ((qty - 1) == stok) {
                    $('#qty').val(stok)
                } else {
                    $('#qty').val(qty)
                }
            })

            $('#detail').on('click', '.beli_sekarang', function() {
                var token = $("meta[name='csrf-token']").attr("content");
                var kode = $(this).attr("data-kd");
                var qty = $('#qty').val();
                $.ajax({
                    type: "post",
                    url: "{{ route('cart.add2') }}",
                    data: {
                        kode: kode,
                        qty: qty,
                        _token: token,
                    },
                    success: function(data) {
                        document.location.href = "/keranjang";
                    },
                });
            })
            $('#detail').on('click', '.keranjang', function() {
                var token = $("meta[name='csrf-token']").attr("content");
                var kode = $(this).attr("data-kd");
                var qty = $('#qty').val();
                $.ajax({
                    type: "post",
                    url: "{{ route('cart.add2') }}",
                    data: {
                        kode: kode,
                        qty: qty,
                        _token: token,
                    },
                    success: function(data) {
                        document.location.href = "";
                    },
                });
            })
        </script>
    </x-slot:foot>
</x-user.content>
